/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: OS_Includes.h $:

  Description:
    Header file for OS specific functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2013-02-05  add file header
    2013-02-05  initial version

**************************************************************************************/

#ifndef __OS_INCLUDES__H
#define __OS_INCLUDES__H

#include "Windows.h"
#include <stdio.h>
#include <stdlib.h>

#undef SLIST_ENTRY
#pragma warning(disable : 4127 )  /* Disable conditional expression is constant (used in TAILQ) */
#pragma warning(disable : 4152 )  /* Disable nonstandard extension (thrown by PtrToLong)        */

#define PTR2LONG PtrToLong
#define LONG2PTR LongToPtr

#ifndef OS_Min
  #define OS_Min(a,b)   ((a < b)? (a) : (b))
#endif /* min */

#ifndef OS_Max
  #define OS_Max(a,b)   ((a > b)? (a) : (b))
#endif /* max */

typedef void    (*PFN_THREAD_FUNCTION)        ( void* pvParam);

typedef struct WIN32_THREAD_PARAM_Ttag
{
  LPSECURITY_ATTRIBUTES  lptSecAtt;
  SIZE_T                 tStackSize;
  LPTHREAD_START_ROUTINE lpStartAddr;
  LPVOID                 pvParam;
  DWORD                  dwFlags;
  DWORD                  lpID;
  HANDLE                 hHandle;
  PFN_THREAD_FUNCTION    pfnThreadFunction;
  void*                  pvUserParam;

} WIN32_THREAD_PARAM_T, *PWIN32_THREAD_PARAM_T;

#endif /*  __OS_INCLUDES__H */
